/*   INF3105 - Structures de données et algorithmes
     Laboratoire 3
     Eric Beaudry                                     */

#include <algorithm>
#include "nuage.h"

// Retourne une référence sur point le plus proche de p dans le nuage
const Point& Nuage::proche(const Point& p) const
{
    int ippp = 0; // index point + proche
    double mindistance = points[ippp].distance(p);
    for(int i=1;i<points.taille();i++){
        double d = points[i].distance(p);
        if(d<mindistance) {
            mindistance = d;
            ippp = i;
        }
    }
    return points[ippp];
}

// Retourne un sous-nuage à l'intérieur d'un rayon autour de p
Nuage Nuage::proches(const Point& p, double rayon) const
{
    Nuage result;
    for(int i=0;i<points.taille();i++){
        if(points[i].distance(p) < rayon)
            result.points.ajouter(points[i]);
    }
    return result;
}

class PairePointDistance{
  public:
    double distance;
    int index;
    bool operator < (const PairePointDistance& o)const{
       return distance < o.distance;
    }
};

// Retourne un sous-nuage contenant les n points les plus proches de p
Nuage Nuage::nproches(const Point& p, int n) const
{
    PairePointDistance* paires = new PairePointDistance[points.taille()];
    for(int i=0;i<points.taille();i++){
        paires[i].index = i;
        paires[i].distance = points[i].distance(p);
    }
    
    std::sort(paires, paires + points.taille());
    if(n>points.taille()) n = points.taille();
    Nuage result;
    for(int i=0;i<n;i++)
        result.points.ajouter(points[paires[i].index]);
    delete[] paires;
    return result;
}

// Écriture d'un nuage de points
std::ostream& operator << (std::ostream& os, const Nuage& nuage){
  for(int i=0;i<nuage.points.taille();i++)
    os << nuage.points[i] << std::endl;
  return os;
}

// Lecture d'un nuage de points
std::istream& operator >> (std::istream& is, Nuage& nuage){
  nuage.points.vider();
  while(is){
    Point p;
    is >> p >> std::ws;
    if(is) // Détection de la fin du fichier
      nuage.points.ajouter(p);
  }
  return is;
}
